IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA')
BEGIN

CREATE TABLE [dbo].[RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA](
	[ID]					BIGINT IDENTITY(1, 1) NOT NULL,
	[ID_PROMOCAO]			BIGINT NOT NULL,
	[CD_EMP]				INT NOT NULL,
	[CD_ARV_MERC_CATEG]		INT NOT NULL,
	[DS_ARV_MERC_CATEG]		VARCHAR(200) NOT NULL,
	[ID_NIVEL]				INT NOT NULL,
	[PERC_DESC]				MONEY NOT NULL,
	[VLR_UNIT]				MONEY NOT NULL,
	CONSTRAINT PK_RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA PRIMARY KEY CLUSTERED ([ID])
) ON [PRIMARY]

END
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA_EST_ARV_MERC_CATEGORIA')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA ADD CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA_EST_ARV_MERC_CATEGORIA FOREIGN KEY (CD_EMP, CD_ARV_MERC_CATEG) REFERENCES EST_ARV_MERC_CATEGORIA (CD_EMP, CD_ARV_MERC_CATEG)
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA CHECK CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA_EST_ARV_MERC_CATEGORIA
END
GO


IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA_RC_CLI_BEM_MAIS_PROMOCAO')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA ADD CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA_RC_CLI_BEM_MAIS_PROMOCAO FOREIGN KEY (ID_PROMOCAO) REFERENCES RC_CLI_BEM_MAIS_PROMOCAO (ID)
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA CHECK CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA_RC_CLI_BEM_MAIS_PROMOCAO
END
GO

IF NOT EXISTS (SELECT * FROM SYS.indexes WHERE NAME = 'UK_RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA_ID_PROMOCAO_CD_EMP_CD_ARV_MERC_CATEG')
BEGIN
	CREATE UNIQUE INDEX UK_RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA_ID_PROMOCAO_CD_EMP_CD_ARV_MERC_CATEG ON RC_CLI_BEM_MAIS_PROMOCAO_EST_ARV_MERC_CATEGORIA (ID_PROMOCAO, CD_EMP, CD_ARV_MERC_CATEG)
END